//********************************************************************
//  StyleGUI2.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 5.25 (5E, p. 289)
//********************************************************************

import javax.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.*;

public class StyleGUI2
{
   private final int WIDTH = 300, HEIGHT = 100, FONT_SIZE = 36;
   private JLabel saying;
   private JCheckBox bold, italic;
   private JPanel primary;
   private JTextField fontSizeField;

   //-----------------------------------------------------------------
   //  Sets up a panel with a label and some check boxes that
   //  control the style of the label's font.
   //-----------------------------------------------------------------
   public StyleGUI2()
   {
      saying = new JLabel ("Say it with style!");
      saying.setFont (new Font ("Helvetica", Font.PLAIN, FONT_SIZE));

      bold = new JCheckBox ("Bold");
      bold.setBackground (Color.cyan);
      italic = new JCheckBox ("Italic");
      italic.setBackground (Color.cyan);

      JLabel fontSizeLabel = new JLabel("Font Size");
      fontSizeField = new JTextField(5);
      fontSizeField.setText(String.valueOf(FONT_SIZE));

      StyleListener listener = new StyleListener();
      bold.addItemListener (listener);
      italic.addItemListener (listener);

      FieldListener l = new FieldListener();
      fontSizeField.addActionListener (l);

      primary = new JPanel();
      primary.add (saying);
      primary.add (bold);
      primary.add (italic);
      primary.add (fontSizeLabel);
      primary.add (fontSizeField);
      primary.setBackground (Color.yellow);
      primary.setPreferredSize (new Dimension(WIDTH, HEIGHT));
   }

   //-----------------------------------------------------------------
   //  Returns the primary panel containing the GUI.
   //-----------------------------------------------------------------
   public JPanel getPanel()
   {
      return primary;
   }


   //--------------------------------------------------------------
   //  Updates the style and font size of the label font style.
   //--------------------------------------------------------------
   public void updateLabel ()
   {
      int style = Font.PLAIN;

      if (bold.isSelected())
         style = Font.BOLD;

      if (italic.isSelected())
         style += Font.ITALIC;
      int fontSize = Integer.parseInt(fontSizeField.getText());

      saying.setFont (new Font ("Helvetica", style, fontSize));
   }

   //*****************************************************************
   //  Represents the listener for both check boxes
   //*****************************************************************
   private class StyleListener implements ItemListener
   {
      //--------------------------------------------------------------
      //  Updates the style and font size of the label font style.
      //--------------------------------------------------------------
      public void itemStateChanged (ItemEvent event)
      {
         updateLabel();
      }
   }

   private class FieldListener implements ActionListener
   {
      public void actionPerformed (ActionEvent event)
      {
         updateLabel();
      }
   }

}
